
function ICDE(fhd,ii,jj,kk,args)

%% Parameter definition
global proc
global ps
% Reinitialization of local function evaluation counter.
proc.i_eval = 0;
% Function evaluation at which the last update of the global best solution occurred.
proc.last_improvement = 1;
% Signalizing to stop running.
proc.finish = 0;   
% Population size.
mu = 30;
lambda = 3 * mu;
% Dimensionality of test case.
D = ps.D;
% Max function evaluation.
MaxFES = proc.n_eval;                        
% Total generation number.
totalGen = ceil(MaxFES / lambda) + 1;
% The value of threshold parameter.
r = 0.8;
% The threshold generation.
threshold_gen = ceil(r * totalGen);
% Individuals' lower bounds.
Vmin = ps.x_min;
% Individuals' upper bounds.
Vmax = ps.x_max;

%% Initialization
if length(Vmin) == 1
    Vmin = repmat(Vmin,1,D);
    Vmax = repmat(Vmax,1,D);
end
lu = [Vmin; Vmax];
Vmin = repmat(Vmin,mu,1);
Vmax = repmat(Vmax,mu,1);
in_var = Vmin + (Vmax - Vmin) .* rand(mu,D);   
% Initialize the value of generation
gen = 1;
% Evaluate fitness of initial population
args{3} = mu;
[fit, obj, g_sum, in_var_RO] = feval(fhd, ii, jj, kk, args, in_var);
% Record objective values and constraint violation value
Ob_coV = zeros(mu, 2); 
Ob_coV(1 : mu, 1) = obj'; 
Ob_coV(1 : mu, 2) = g_sum';

%% Evolutionary main loop
while 1
    % Generate the offspring population 
    off_var = select_reproduce(in_var, mu, lu, D, gen, threshold_gen, totalGen);
    % Evaluate fitness of offspring population
    args{3} = lambda;
    [fit, obj, g_sum, off_var_RO] = feval(fhd, ii, jj, kk, args, off_var);
    % Combine parent and offspring population
    in_var(((mu + 1):(mu + lambda)),:) = off_var;
    % Record objective values and constraint violation value
    Ob_coV_off = zeros(lambda,2);
    Ob_coV_off(1 : lambda, 1) = obj'; 
    Ob_coV_off(1 : lambda, 2) = g_sum';
    % Combine parent and offspring Ob_coV
    Ob_coV(((mu + 1):(mu + lambda)),:) = Ob_coV_off;
    
    % If the number of the generation is larger than 1 and the combined population is an infeasible population, then do as follows
    if args{1} ~= 41 && gen > 1 && length(find(Ob_coV(:,2) > 1E-04)) == size(Ob_coV,1)
                
        ind_index = find(non_elite_fit(:,2) < coV_max);
        
        add_num = length(ind_index);

        in_var(((lambda + mu + 1):(lambda + mu + add_num)),:) = non_elite_x(ind_index,:);
        Ob_coV(((lambda + mu + 1):(lambda + mu + add_num)),:) = non_elite_fit(ind_index,:);

    end
    
    total_ind_num = size(Ob_coV,1);
    percent = length(find(Ob_coV(:,2) <= 1E-04)) / total_ind_num;

    %  For 41 bus system the combined population has only infeasible individuals
    if args{1} == 41 && percent == 0
        
        % Sort the population according to constraint violation value
        [fitVal, fitIndex] = sort(Ob_coV(:,2));
        in_var = in_var(fitIndex, :);
        Ob_coV = Ob_coV(fitIndex, :);
        
        % Select the the first mu/2 and then randomly select the second half
        [randVal, randIndex] = sort(rand(1, lambda/2));
        selectIndex = [1 : mu/2, randIndex(1:mu/2) + mu/2];
        in_var = in_var(selectIndex, :);
        Ob_coV = Ob_coV(selectIndex, :);
    
    % For other systems the combined population has only infeasible individuals
    elseif args{1} ~= 41 && percent == 0

        % Select mu individuals from the combined population
        nouse = replacement(Ob_coV,total_ind_num,mu);

        % Store all the remaining individuals into the population 'non_elite_x'
        non_elite_x = in_var;
        non_elite_x(nouse,:) = [];
        non_elite_fit = Ob_coV;
        non_elite_fit(nouse,:) = [];

        % Obtain the new parent population
        in_var = in_var(nouse,:);
        Ob_coV = Ob_coV(nouse,:);
        
        coV_max = max(Ob_coV(:,2));
        
    % The population contains some feasible solutions
    elseif percent > 0 && percent < 1

        % Record the subscripts of the feasible solutions
        Z1 = find(Ob_coV(:, 2) <= 1E-04 );

        % Record the subscripts of the infeasible solutions
        Z2 = find(Ob_coV(:, 2) > 1E-04 );

        % objFun denotes the objective function of the population
        objFun = Ob_coV(:, 1);
                    
        % conVio denotes the degree of constraint violation of the population
        conVio = Ob_coV(:, 2);

        % Compute the minimum and maximum objective function values of the feasible solutions
        minObjFun = min(objFun(Z1));
        maxObjFun = max(objFun(Z1));
        
        % Compute the minimum and maximum degree of constraint violation of the infeasible solutions in the population
        minConVio = min(conVio(Z2));
        maxConVio = max(conVio(Z2));
                    
        % Modify the objective function
        objFun(Z2) = max(objFun(Z2), ones(size(Z2, 1), 1) * (percent * minObjFun + (1 - percent) * maxObjFun));

        % Normalize the objective function
        norObjFun = (objFun - min(objFun))./((max(objFun) - min(objFun)) + 1E-30);
        
        % Normalize the degree of constraint violations
        norConVio = conVio;
        norConVio(Z2) = (conVio(Z2) - minConVio) ./ (maxConVio - minConVio + 1E-30);

        % Obtain the final objective function
        finalFit = norObjFun + norConVio;
        
        % Choose the items for the next population
        [fitVal, fitIndex] = sort(finalFit);
        in_var = in_var(fitIndex(1 : mu), :);
        Ob_coV = Ob_coV(fitIndex(1 : mu), :);

    % The population contains only feasible solutions
    elseif percent == 1

        % Choose the items for the next population(Under this condition, we only need to consider the objective function value)
        [fitVal, fitIndex] = sort(Ob_coV(:, 1));
        in_var = in_var(fitIndex(1 : mu), :);
        Ob_coV = Ob_coV(fitIndex(1 : mu), :);

    end
    
    % Update the generation number
    gen = gen + 1;

    if proc.finish
        return;
    end    
end